<?php
// admin/dashboard.php
require_once __DIR__ . '/../inc/config.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/functions.php';
require_admin();

$mysqli = get_db();

// fetch cars
$res = $mysqli->query("
    SELECT c.*, 
    (SELECT filename FROM car_images ci WHERE ci.car_id=c.id AND ci.is_primary=1 LIMIT 1) AS img 
    FROM cars c ORDER BY c.created_at DESC
");
$cars = $res->fetch_all(MYSQLI_ASSOC);

// Statistics
$count_total = $mysqli->query("SELECT COUNT(*) AS ct FROM cars")->fetch_assoc()['ct'];
$count_hot = $mysqli->query("SELECT COUNT(*) AS ct FROM cars WHERE is_hot_deal=1")->fetch_assoc()['ct'];
$count_featured = $mysqli->query("SELECT COUNT(*) AS ct FROM cars WHERE is_featured=1")->fetch_assoc()['ct'];
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin Dashboard</title>
  <link rel="stylesheet" href="../public/assets/css/style.css">

  <style>
    body {
      background:#f5f6fa;
      font-family: Arial, sans-serif;
    }
    .admin-wrapper {
      display:flex;
      min-height:100vh;
    }
    /* SIDEBAR */
    .sidebar {
      width:250px;
      background:#111827;
      color:#fff;
      padding:20px 0;
    }
    .sidebar h3 {
      text-align:center;
      margin-bottom:20px;
      font-size:22px;
    }
    .sidebar a {
      display:block;
      padding:12px 20px;
      color:#e5e7eb;
      text-decoration:none;
      font-size:16px;
    }
    .sidebar a:hover {
      background:#1f2937;
      color:#fff;
    }

    /* TOP BAR */
    .topbar {
      background:#fff;
      padding:15px 25px;
      display:flex;
      justify-content:space-between;
      align-items:center;
      border-bottom:1px solid #ddd;
    }

    /* CONTENT */
    .content {
      flex:1;
      padding:25px;
    }

    .cards {
      display:grid;
      grid-template-columns:repeat(auto-fit, minmax(220px, 1fr));
      gap:20px;
    }

    .card-box {
      background:#fff;
      padding:20px;
      border-radius:10px;
      box-shadow:0 2px 10px rgba(0,0,0,0.05);
      text-align:center;
    }
    .card-box h4 {
      font-size:14px;
      color:#6b7280;
      margin-bottom:10px;
    }
    .card-box p {
      font-size:24px;
      font-weight:bold;
      margin:0;
      color:#111827;
    }

    h2.title {
      margin-top:30px;
      margin-bottom:15px;
      font-size:22px;
      font-weight:bold;
    }

    /* TABLE */
    table {
      width:100%;
      border-collapse:collapse;
      background:#fff;
      box-shadow:0 2px 10px rgba(0,0,0,0.05);
      border-radius:10px;
      overflow:hidden;
    }
    thead {
      background:#111827;
      color:#fff;
    }
    th, td {
      padding:12px 15px;
      border-bottom:1px solid #e5e7eb;
      font-size:15px;
    }
    tr:hover {
      background:#f9fafb;
    }
    img.thumb {
      width:70px;
      height:50px;
      object-fit:cover;
      border-radius:6px;
    }

    /* ACTION BUTTONS */
    .btn-edit {
      color:#0ea5e9;
      text-decoration:none;
      font-weight:bold;
    }
    .btn-delete {
      color:#ef4444;
      text-decoration:none;
      font-weight:bold;
    }
    .add-btn {
      background:#2563eb;
      color:#fff;
      padding:10px 18px;
      border-radius:6px;
      text-decoration:none;
      font-weight:bold;
      float:right;
      margin-bottom:10px;
    }
    .add-btn:hover {
      background:#1d4ed8;
    }
  </style>
</head>

<body>

<div class="admin-wrapper">

  <!-- SIDEBAR -->
  <div class="sidebar">
    <h3>Admin Panel</h3>
    <a href="dashboard.php">Dashboard</a>
    <a href="add_car.php">Add New Car</a>
    <a href="cars.php">Manage Cars</a>
    <a href="settings.php">Settings</a>
    <a href="logout.php" style="color:#f87171;">Logout</a>
  </div>

  <!-- MAIN AREA -->
  <div class="main-area" style="flex:1">

    <!-- TOP BAR -->
    <div class="topbar">
      <h3>Welcome, Admin</h3>
      <div>
        <span style="margin-right:20px;color:#4b5563;">Today: <?php echo date("d M Y"); ?></span>
      </div>
    </div>

    <!-- CONTENT -->
    <div class="content">

      <!-- SUMMARY CARDS -->
      <div class="cards">
        <div class="card-box">
          <h4>Total Cars</h4>
          <p><?php echo $count_total; ?></p>
        </div>
        <div class="card-box">
          <h4>Hot Deals</h4>
          <p><?php echo $count_hot; ?></p>
        </div>
        <div class="card-box">
          <h4>Featured Cars</h4>
          <p><?php echo $count_featured; ?></p>
        </div>
      </div>

      <h2 class="title">Cars List 
        <a class="add-btn" href="add_car.php">+ Add Car</a>
      </h2>

      <!-- TABLE -->
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Car</th>
            <th>Price</th>
            <th>Year</th>
            <th>Hot</th>
            <th>Featured</th>
            <th>Actions</th>
          </tr>
        </thead>

        <tbody>
        <?php foreach($cars as $c): ?>
          <tr>
            <td><?php echo e($c['id']); ?></td>

            <td>
              <div style="display:flex;align-items:center;gap:10px;">
                <img src="../uploads/<?php echo e($c['img']); ?>" class="thumb" alt="">
                <strong><?php echo e($c['title']); ?></strong>
              </div>
            </td>

            <td>Ksh <?php echo number_format($c['price']); ?></td>
            <td><?php echo e($c['year']); ?></td>
            <td><?php echo $c['is_hot_deal'] ? '🔥 Yes' : '—'; ?></td>
            <td><?php echo $c['is_featured'] ? '⭐ Yes' : '—'; ?></td>

            <td>
              <a class="btn-edit" href="edit_car.php?id=<?php echo $c['id']; ?>">Edit</a> | 
              <a class="btn-delete" href="delete_car.php?id=<?php echo $c['id']; ?>" onclick="return confirm('Delete this car?');">Delete</a>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>

    </div>
  </div>

</div>

</body>
</html>
